############### ###############
## Expectations Survey
## F_Expectations_2
## Project: CBO
## PI: Malte Lierl
## Written by: Malte Lierl
## Purpose: Visualize data from the expectations survey
## Date of creation: 2022-11-07
## This version: 2022-11-07
############### ###############

#Expectations for H3 were measured on a scale from -200 to 200, corresponding to -10 percentage points to +10 percentage points change in probability

mean.expectations.2 <- rbind(c("H3: Perceived civil society pressure", 3, mean_ci(expectations$H3_cspressure/20)),
                          c("H3: CBOs among top 3 actors to keep happy", 2, mean_ci(expectations$H3_keephappy/20)),
                          c("H3: CBOs among top 3 actors requiring justification", 1, mean_ci(expectations$H3_justification/20)))

colnames(mean.expectations.2) <- c("Hypothesis", "Position", "Mean", "Lower95", "Upper95")
mean.expectations.2 <- data.frame(mean.expectations.2)
mean.expectations.2$Position <- as.numeric(mean.expectations.2$Position)
mean.expectations.2$Mean <- as.numeric(mean.expectations.2$Mean)
mean.expectations.2$Lower95 <- as.numeric(mean.expectations.2$Lower95)
mean.expectations.2$Upper95 <- as.numeric(mean.expectations.2$Upper95)
mean.expectations.2

plot.expectations.2 <- ggplot(data=expectations) +
  geom_vline(aes(xintercept=0), lty=2) + 
  geom_hline(aes(yintercept=Position), lty=3, alpha=0.3, data=mean.expectations.2) + 
  geom_point(aes(x=H3_cspressure/20, y=3), alpha=0.3, size=3, color="cadetblue") +   
  geom_point(aes(x=H3_keephappy/20, y=2), alpha=0.3, size=3, color="cadetblue") + 
  geom_point(aes(x=H3_justification/20, y=1), alpha=0.3, size=3, color="cadetblue") + 
  geom_errorbarh(aes(xmin=Lower95, xmax=Upper95, y=Position, height=0.2), lwd=1, color="firebrick4", data=mean.expectations.2) + 
  geom_point(aes(x=Mean, y=Position), shape=5, size=3, stroke=2, color="firebrick", data=mean.expectations.2) + 
  coord_cartesian(ylim=c(1,3), xlim=c(-10, 10)) + 
  scale_x_continuous(name="Expected effect size (in percentage points)", breaks=c(-10, -5, 0, 5, 10)) + 
  scale_y_continuous(name="Outcome", breaks=mean.expectations.2$Position, labels=mean.expectations.2$Hypothesis) + 
  theme_few()  
ggsave(plot.expectations.2, file=here("Output", "For Publication", "Figures", "F_Expectations_2.png"), width=8, height=2.6)

